/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.data.CyclicFile;
import com.lothrazar.cyclic.event.PlayerDataEvents;
import com.lothrazar.cyclic.item.elemental.FireballItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerAbilityEvents {
    private static final int DISABLE_OFFSET = 6;

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FireballItem.tickHoldingFireball(player);
            CyclicFile datFile = PlayerDataEvents.getOrCreate(player);
            this.tickFlying(player, datFile);
            this.tickSpec(player, datFile);
        }
    }

    private void tickSpec(Player player, CyclicFile datFile) {
        if (datFile.spectatorTicks <= 0) {
            datFile.spectatorTicks = 0;
            return;
        }
        if (datFile.spectatorTicks > 6) {
            player.f_19794_ = true;
        } else if (datFile.spectatorTicks <= 6) {
            player.f_19794_ = false;
        }
        --datFile.spectatorTicks;
    }

    private void tickFlying(Player player, CyclicFile datFile) {
        if (datFile.flyTicks <= 0) {
            datFile.flyTicks = 0;
            return;
        }
        if (datFile.flyTicks > 6) {
            player.m_150110_().f_35936_ = true;
        } else if (datFile.flyTicks <= 6) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
            player.f_19789_ = 0.0f;
        }
        --datFile.flyTicks;
    }
}

